/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartCanvas;
import jclass.chart.DerivedInt;
import jclass.chart.Drawable;
import jclass.chart.JCBorderStyle;
import jclass.chart.TrackChange;

public class ChartRegion
extends TrackChange
implements Drawable,
JCSerializable {
    JCBorderStyle borderStyle;
    DerivedInt left = new DerivedInt(0, true);
    DerivedInt top = new DerivedInt(0, true);
    DerivedInt width = new DerivedInt(0, true);
    DerivedInt height = new DerivedInt(0, true);
    private Font font;
    String name;
    private Color foreground;
    private Color background;
    ChartCanvas parent;
    boolean isShowing = true;
    boolean updateParent = true;

    public ChartRegion() {
    }

    public ChartRegion(ChartCanvas chartCanvas) {
        this.setParent(chartCanvas);
    }

    public synchronized void setParent(ChartCanvas chartCanvas) {
        this.parent = chartCanvas;
        if (this.parent == null) {
            return;
        }
    }

    public Font getFont() {
        if (this.font == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getFont();
        }
        return this.font;
    }

    public synchronized void setFont(Font font) {
        if (font == null || font == this.font) {
            return;
        }
        this.font = font;
        this.setChanged(true);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        this.name = string;
    }

    public Color getForeground() {
        if (this.foreground == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getForeground();
        }
        return this.foreground;
    }

    public synchronized void setForeground(Color color) {
        if (color == null || color == this.foreground) {
            return;
        }
        this.foreground = color;
        this.setChanged(true);
    }

    public Color getBackground() {
        if (this.background == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getBackground();
        }
        return this.background;
    }

    public synchronized void setBackground(Color color) {
        if (color == null || color == this.background) {
            return;
        }
        this.background = color;
        this.setChanged(true);
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public synchronized void setIsShowing(boolean bl) {
        if (this.isShowing == bl) {
            return;
        }
        this.isShowing = bl;
        this.setChanged(true);
    }

    public void recalc() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.left.isDefault) {
            this.left.value = n;
        }
        if (this.top.isDefault) {
            this.top.value = n2;
        }
        if (this.width.isDefault) {
            this.width.value = n3;
        }
        if (this.height.isDefault) {
            this.height.value = n4;
        }
    }

    public void move(int n, int n2) {
        this.reshape(n, n2, this.width.value, this.height.value);
    }

    public void resize(int n, int n2) {
        this.reshape(this.left.value, this.top.value, n, n2);
    }

    public synchronized void setTop(int n) {
        if (this.top.value == n) {
            return;
        }
        this.top.value = n;
        this.top.isDefault = false;
        this.setChanged(true);
    }

    public int getTop() {
        return this.top.value;
    }

    public synchronized void setTopIsDefault(boolean bl) {
        if (this.top.isDefault == bl) {
            return;
        }
        this.top.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getTopIsDefault() {
        return this.top.isDefault;
    }

    public synchronized void setLeft(int n) {
        if (this.left.value == n) {
            return;
        }
        this.left.value = n;
        this.left.isDefault = false;
        this.setChanged(true);
    }

    public int getLeft() {
        return this.left.value;
    }

    public synchronized void setLeftIsDefault(boolean bl) {
        if (this.left.isDefault == bl) {
            return;
        }
        this.left.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getLeftIsDefault() {
        return this.left.isDefault;
    }

    public synchronized void setWidth(int n) {
        if (this.width.value == n) {
            return;
        }
        this.width.value = n;
        this.width.isDefault = false;
        this.setChanged(true);
    }

    public int getWidth() {
        return this.width.value;
    }

    public synchronized void setWidthIsDefault(boolean bl) {
        if (this.width.isDefault == bl) {
            return;
        }
        this.width.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getWidthIsDefault() {
        return this.width.isDefault;
    }

    public synchronized void setHeight(int n) {
        if (this.height.value == n) {
            return;
        }
        this.height.value = n;
        this.height.isDefault = false;
        this.setChanged(true);
    }

    public int getHeight() {
        return this.height.value;
    }

    public synchronized void setHeightIsDefault(boolean bl) {
        if (this.height.isDefault == bl) {
            return;
        }
        this.height.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getHeightIsDefault() {
        return this.height.isDefault;
    }

    public synchronized void setBorderType(int n) {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        this.borderStyle.setType(n);
    }

    public int getBorderType() {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        return this.borderStyle.getType();
    }

    public synchronized void setBorderWidth(int n) {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        this.borderStyle.setWidth(n);
    }

    public int getBorderWidth() {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        return this.borderStyle.getWidth();
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (this.background != null) {
            if (graphics.getColor() != this.background) {
                graphics.setColor(this.background);
            }
            graphics.fillRect(this.left.value, this.top.value, this.width.value, this.height.value);
        }
        if (this.borderStyle == null) {
            return;
        }
        this.borderStyle.draw(graphics, this.left.value, this.top.value, this.width.value, this.height.value, this.getBackground(), this.getForeground());
    }

    public void setChanged(boolean bl) {
        if (bl == this.getChanged()) {
            return;
        }
        super.setChanged(bl);
        if (bl && this.parent != null && this.updateParent) {
            this.parent.setChanged(bl);
        }
    }
}

